<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductRush StructType
 * @subpackage Structs
 */
class ProductRush extends AbstractStructBase
{
    /**
     * The productNumber
     * @var string
     */
    public $productNumber;
    /**
     * The isRush
     * @var bool
     */
    public $isRush;
    /**
     * Constructor method for ProductRush
     * @uses ProductRush::setProductNumber()
     * @uses ProductRush::setIsRush()
     * @param string $productNumber
     * @param bool $isRush
     */
    public function __construct($productNumber = null, $isRush = null)
    {
        $this
            ->setProductNumber($productNumber)
            ->setIsRush($isRush);
    }
    /**
     * Get productNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->productNumber;
    }
    /**
     * Set productNumber value
     * @param string $productNumber
     * @return \StructType\ProductRush
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->productNumber = $productNumber;
        return $this;
    }
    /**
     * Get isRush value
     * @return bool|null
     */
    public function getIsRush()
    {
        return $this->isRush;
    }
    /**
     * Set isRush value
     * @param bool $isRush
     * @return \StructType\ProductRush
     */
    public function setIsRush($isRush = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRush) && !is_bool($isRush)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRush, true), gettype($isRush)), __LINE__);
        }
        $this->isRush = $isRush;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductRush
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
