<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductColorData StructType
 * @subpackage Structs
 */
class ProductColorData extends AbstractStructBase
{
    /**
     * The color_id
     * @var string
     */
    public $color_id;
    /**
     * The part_number
     * @var string
     */
    public $part_number;
    /**
     * The product_number
     * @var string
     */
    public $product_number;
    /**
     * The color
     * @var string
     */
    public $color;
    /**
     * The is_outlet
     * @var bool
     */
    public $is_outlet;
    /**
     * Constructor method for ProductColorData
     * @uses ProductColorData::setColor_id()
     * @uses ProductColorData::setPart_number()
     * @uses ProductColorData::setProduct_number()
     * @uses ProductColorData::setColor()
     * @uses ProductColorData::setIs_outlet()
     * @param string $color_id
     * @param string $part_number
     * @param string $product_number
     * @param string $color
     * @param bool $is_outlet
     */
    public function __construct($color_id = null, $part_number = null, $product_number = null, $color = null, $is_outlet = null)
    {
        $this
            ->setColor_id($color_id)
            ->setPart_number($part_number)
            ->setProduct_number($product_number)
            ->setColor($color)
            ->setIs_outlet($is_outlet);
    }
    /**
     * Get color_id value
     * @return string|null
     */
    public function getColor_id()
    {
        return $this->color_id;
    }
    /**
     * Set color_id value
     * @param string $color_id
     * @return \StructType\ProductColorData
     */
    public function setColor_id($color_id = null)
    {
        // validation for constraint: string
        if (!is_null($color_id) && !is_string($color_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color_id, true), gettype($color_id)), __LINE__);
        }
        $this->color_id = $color_id;
        return $this;
    }
    /**
     * Get part_number value
     * @return string|null
     */
    public function getPart_number()
    {
        return $this->part_number;
    }
    /**
     * Set part_number value
     * @param string $part_number
     * @return \StructType\ProductColorData
     */
    public function setPart_number($part_number = null)
    {
        // validation for constraint: string
        if (!is_null($part_number) && !is_string($part_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($part_number, true), gettype($part_number)), __LINE__);
        }
        $this->part_number = $part_number;
        return $this;
    }
    /**
     * Get product_number value
     * @return string|null
     */
    public function getProduct_number()
    {
        return $this->product_number;
    }
    /**
     * Set product_number value
     * @param string $product_number
     * @return \StructType\ProductColorData
     */
    public function setProduct_number($product_number = null)
    {
        // validation for constraint: string
        if (!is_null($product_number) && !is_string($product_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_number, true), gettype($product_number)), __LINE__);
        }
        $this->product_number = $product_number;
        return $this;
    }
    /**
     * Get color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param string $color
     * @return \StructType\ProductColorData
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get is_outlet value
     * @return bool|null
     */
    public function getIs_outlet()
    {
        return $this->is_outlet;
    }
    /**
     * Set is_outlet value
     * @param bool $is_outlet
     * @return \StructType\ProductColorData
     */
    public function setIs_outlet($is_outlet = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_outlet) && !is_bool($is_outlet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_outlet, true), gettype($is_outlet)), __LINE__);
        }
        $this->is_outlet = $is_outlet;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductColorData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
