<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeactivatedProduct StructType
 * @subpackage Structs
 */
class DeactivatedProduct extends AbstractStructBase
{
    /**
     * The variation
     * @var string
     */
    public $variation;
    /**
     * The partNumber
     * @var string
     */
    public $partNumber;
    /**
     * The deactivatedDate
     * @var string
     */
    public $deactivatedDate;
    /**
     * Constructor method for DeactivatedProduct
     * @uses DeactivatedProduct::setVariation()
     * @uses DeactivatedProduct::setPartNumber()
     * @uses DeactivatedProduct::setDeactivatedDate()
     * @param string $variation
     * @param string $partNumber
     * @param string $deactivatedDate
     */
    public function __construct($variation = null, $partNumber = null, $deactivatedDate = null)
    {
        $this
            ->setVariation($variation)
            ->setPartNumber($partNumber)
            ->setDeactivatedDate($deactivatedDate);
    }
    /**
     * Get variation value
     * @return string|null
     */
    public function getVariation()
    {
        return $this->variation;
    }
    /**
     * Set variation value
     * @param string $variation
     * @return \StructType\DeactivatedProduct
     */
    public function setVariation($variation = null)
    {
        // validation for constraint: string
        if (!is_null($variation) && !is_string($variation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variation, true), gettype($variation)), __LINE__);
        }
        $this->variation = $variation;
        return $this;
    }
    /**
     * Get partNumber value
     * @return string|null
     */
    public function getPartNumber()
    {
        return $this->partNumber;
    }
    /**
     * Set partNumber value
     * @param string $partNumber
     * @return \StructType\DeactivatedProduct
     */
    public function setPartNumber($partNumber = null)
    {
        // validation for constraint: string
        if (!is_null($partNumber) && !is_string($partNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partNumber, true), gettype($partNumber)), __LINE__);
        }
        $this->partNumber = $partNumber;
        return $this;
    }
    /**
     * Get deactivatedDate value
     * @return string|null
     */
    public function getDeactivatedDate()
    {
        return $this->deactivatedDate;
    }
    /**
     * Set deactivatedDate value
     * @param string $deactivatedDate
     * @return \StructType\DeactivatedProduct
     */
    public function setDeactivatedDate($deactivatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($deactivatedDate) && !is_string($deactivatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deactivatedDate, true), gettype($deactivatedDate)), __LINE__);
        }
        $this->deactivatedDate = $deactivatedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeactivatedProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
