<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Category StructType
 * @subpackage Structs
 */
class Category extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The subcategories
     * Meta information extracted from the WSDL
     * - arrayType: tns:SubcategoryId[]
     * - base: soap-enc:Array
     * - ref: soap-enc:arrayType
     * @var \StructType\SubcategoryId[]
     */
    public $subcategories;
    /**
     * Constructor method for Category
     * @uses Category::setId()
     * @uses Category::setName()
     * @uses Category::setSubcategories()
     * @param string $id
     * @param string $name
     * @param \StructType\SubcategoryId[] $subcategories
     */
    public function __construct($id = null, $name = null, array $subcategories = array())
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setSubcategories($subcategories);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Category
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Category
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get subcategories value
     * @return \StructType\SubcategoryId[]|null
     */
    public function getSubcategories()
    {
        return $this->subcategories;
    }
    /**
     * This method is responsible for validating the values passed to the setSubcategories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubcategories method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubcategoriesForArrayConstraintsFromSetSubcategories(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categorySubcategoriesItem) {
            // validation for constraint: itemType
            if (!$categorySubcategoriesItem instanceof \StructType\SubcategoryId) {
                $invalidValues[] = is_object($categorySubcategoriesItem) ? get_class($categorySubcategoriesItem) : sprintf('%s(%s)', gettype($categorySubcategoriesItem), var_export($categorySubcategoriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subcategories property can only contain items of type \StructType\SubcategoryId, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subcategories value
     * @throws \InvalidArgumentException
     * @param \StructType\SubcategoryId[] $subcategories
     * @return \StructType\Category
     */
    public function setSubcategories(array $subcategories = array())
    {
        // validation for constraint: array
        if ('' !== ($subcategoriesArrayErrorMessage = self::validateSubcategoriesForArrayConstraintsFromSetSubcategories($subcategories))) {
            throw new \InvalidArgumentException($subcategoriesArrayErrorMessage, __LINE__);
        }
        $this->subcategories = $subcategories;
        return $this;
    }
    /**
     * Add item to subcategories value
     * @throws \InvalidArgumentException
     * @param \StructType\SubcategoryId $item
     * @return \StructType\Category
     */
    public function addToSubcategories(\StructType\SubcategoryId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubcategoryId) {
            throw new \InvalidArgumentException(sprintf('The subcategories property can only contain items of type \StructType\SubcategoryId, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subcategories[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Category
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
