<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getOutletProductList
     * Meta information extracted from the WSDL
     * - documentation: Returns list of products in outlet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return Array|bool
     */
    public function getOutletProductList($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getOutletProductList($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInfo
     * Meta information extracted from the WSDL
     * - documentation: Gets the product image and other data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $outlet
     * @return Array|bool
     */
    public function getInfo($customerNumber, $userCredential, $productNumber, $outlet)
    {
        try {
            $this->setResult($this->getSoapClient()->getInfo($customerNumber, $userCredential, $productNumber, $outlet));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLastModified
     * Meta information extracted from the WSDL
     * - documentation: Gets the last modified time for products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return Array|bool
     */
    public function getLastModified($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getLastModified($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductFamilyFromPart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $partNumber
     * @return string|bool
     */
    public function getProductFamilyFromPart($customerNumber, $userCredential, $partNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductFamilyFromPart($customerNumber, $userCredential, $partNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPartsFromProductFamily
     * Meta information extracted from the WSDL
     * - documentation: Get part numbers from product family
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return Array|bool
     */
    public function getPartsFromProductFamily($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getPartsFromProductFamily($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTopSellers
     * Meta information extracted from the WSDL
     * - documentation: Gets the top-selling products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $count
     * @param string $month
     * @param string $year
     * @return Array|bool
     */
    public function getTopSellers($customerNumber, $userCredential, $count, $month, $year)
    {
        try {
            $this->setResult($this->getSoapClient()->getTopSellers($customerNumber, $userCredential, $count, $month, $year));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getColors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @param string $includeOutlet
     * @return \StructType\ProductColorData[]|bool
     */
    public function getColors($customerNumber, $userCredential, $productNumber, $includeOutlet)
    {
        try {
            $this->setResult($this->getSoapClient()->getColors($customerNumber, $userCredential, $productNumber, $includeOutlet));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSetupCharges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductSetupData[]|bool
     */
    public function getSetupCharges($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getSetupCharges($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\ProductImageResult|bool
     */
    public function getImages($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getImages($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductDataCM
     * Meta information extracted from the WSDL
     * - documentation: Return product data in format specified by Cumberland Marketing [TICK:166400] DS - Another Product Service
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string[] $productNumbers
     * @return \StructType\CMProductDataResult[]|bool
     */
    public function getProductDataCM($customerNumber, $userCredential, array $productNumbers)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductDataCM($customerNumber, $userCredential, $productNumbers));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInfoMulti
     * Meta information extracted from the WSDL
     * - documentation: Gets the product image and other data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string[] $productNumbers
     * @param string $outlet
     * @return Array|bool
     */
    public function getInfoMulti($customerNumber, $userCredential, array $productNumbers, $outlet)
    {
        try {
            $this->setResult($this->getSoapClient()->getInfoMulti($customerNumber, $userCredential, $productNumbers, $outlet));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductSizes
     * Meta information extracted from the WSDL
     * - documentation: Gets the product image and other data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return struct|bool
     */
    public function getProductSizes($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductSizes($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductPackingData
     * Meta information extracted from the WSDL
     * - documentation: Get product package data for a product
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return \StructType\RawProductPackingSoap|bool
     */
    public function getProductPackingData($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductPackingData($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductArtTemplates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $productNumber
     * @return string[]|bool
     */
    public function getProductArtTemplates($customerNumber, $userCredential, $productNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductArtTemplates($customerNumber, $userCredential, $productNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActiveProducts
     * Meta information extracted from the WSDL
     * - documentation: Get all active products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param string $includeOutletAndCustom
     * @return \StructType\ActiveProduct[]|bool
     */
    public function getActiveProducts($customerNumber, $userCredential, $includeOutletAndCustom)
    {
        try {
            $this->setResult($this->getSoapClient()->getActiveProducts($customerNumber, $userCredential, $includeOutletAndCustom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductsDeactivated
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\DeactivatedProduct[]|bool
     */
    public function getProductsDeactivated($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductsDeactivated($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\Category[]|bool
     */
    public function getCategories($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getCategories($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductsBySubcategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @param int[] $subcategoriesIds
     * @return \StructType\Subcategory[]|bool
     */
    public function getProductsBySubcategory($customerNumber, $userCredential, array $subcategoriesIds)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductsBySubcategory($customerNumber, $userCredential, $subcategoriesIds));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductDecoration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $customerNumber
     * @param string $userCredential
     * @return \StructType\Decoration[]|bool
     */
    public function getProductDecoration($customerNumber, $userCredential)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductDecoration($customerNumber, $userCredential));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return Array|string|string[]|struct|\StructType\ActiveProduct[]|\StructType\Category[]|\StructType\CMProductDataResult[]|\StructType\DeactivatedProduct[]|\StructType\Decoration[]|\StructType\ProductColorData[]|\StructType\ProductImageResult|\StructType\ProductSetupData[]|\StructType\RawProductPackingSoap|\StructType\Subcategory[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
