<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSiparisDurumRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetSiparisDurumRequest
 * @subpackage Structs
 */
class SetSiparisDurumRequest extends AbstractStructBase
{
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Durum;
    /**
     * The KargoTakipNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoTakipNo;
    /**
     * The MailBilgilendir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MailBilgilendir;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * Constructor method for SetSiparisDurumRequest
     * @uses SetSiparisDurumRequest::setDurum()
     * @uses SetSiparisDurumRequest::setKargoTakipNo()
     * @uses SetSiparisDurumRequest::setMailBilgilendir()
     * @uses SetSiparisDurumRequest::setSiparisID()
     * @param string $durum
     * @param string $kargoTakipNo
     * @param bool $mailBilgilendir
     * @param int $siparisID
     */
    public function __construct($durum = null, $kargoTakipNo = null, $mailBilgilendir = null, $siparisID = null)
    {
        $this
            ->setDurum($durum)
            ->setKargoTakipNo($kargoTakipNo)
            ->setMailBilgilendir($mailBilgilendir)
            ->setSiparisID($siparisID);
    }
    /**
     * Get Durum value
     * @return string|null
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \EnumType\WebSiparisDurumlari::valueIsValid()
     * @uses \EnumType\WebSiparisDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \StructType\SetSiparisDurumRequest
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebSiparisDurumlari::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebSiparisDurumlari', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \EnumType\WebSiparisDurumlari::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get KargoTakipNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoTakipNo()
    {
        return isset($this->KargoTakipNo) ? $this->KargoTakipNo : null;
    }
    /**
     * Set KargoTakipNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoTakipNo
     * @return \StructType\SetSiparisDurumRequest
     */
    public function setKargoTakipNo($kargoTakipNo = null)
    {
        // validation for constraint: string
        if (!is_null($kargoTakipNo) && !is_string($kargoTakipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoTakipNo, true), gettype($kargoTakipNo)), __LINE__);
        }
        if (is_null($kargoTakipNo) || (is_array($kargoTakipNo) && empty($kargoTakipNo))) {
            unset($this->KargoTakipNo);
        } else {
            $this->KargoTakipNo = $kargoTakipNo;
        }
        return $this;
    }
    /**
     * Get MailBilgilendir value
     * @return bool|null
     */
    public function getMailBilgilendir()
    {
        return $this->MailBilgilendir;
    }
    /**
     * Set MailBilgilendir value
     * @param bool $mailBilgilendir
     * @return \StructType\SetSiparisDurumRequest
     */
    public function setMailBilgilendir($mailBilgilendir = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailBilgilendir) && !is_bool($mailBilgilendir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailBilgilendir, true), gettype($mailBilgilendir)), __LINE__);
        }
        $this->MailBilgilendir = $mailBilgilendir;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\SetSiparisDurumRequest
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSiparisDurumRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
