<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberDirectorySearch StructType
 * @subpackage Structs
 */
class MemberDirectorySearch extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The memberIDList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $memberIDList;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The avail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $avail;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $location;
    /**
     * The craft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $craft;
    /**
     * Constructor method for MemberDirectorySearch
     * @uses MemberDirectorySearch::setWebServiceCredentials()
     * @uses MemberDirectorySearch::setMemberIDList()
     * @uses MemberDirectorySearch::setName()
     * @uses MemberDirectorySearch::setAvail()
     * @uses MemberDirectorySearch::setLocation()
     * @uses MemberDirectorySearch::setCraft()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param string $memberIDList
     * @param string $name
     * @param bool $avail
     * @param string $location
     * @param string $craft
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, $memberIDList = null, $name = null, $avail = null, $location = null, $craft = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setMemberIDList($memberIDList)
            ->setName($name)
            ->setAvail($avail)
            ->setLocation($location)
            ->setCraft($craft);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberDirectorySearch
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get memberIDList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberIDList()
    {
        return isset($this->memberIDList) ? $this->memberIDList : null;
    }
    /**
     * Set memberIDList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberIDList
     * @return \StructType\MemberDirectorySearch
     */
    public function setMemberIDList($memberIDList = null)
    {
        // validation for constraint: string
        if (!is_null($memberIDList) && !is_string($memberIDList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberIDList, true), gettype($memberIDList)), __LINE__);
        }
        if (is_null($memberIDList) || (is_array($memberIDList) && empty($memberIDList))) {
            unset($this->memberIDList);
        } else {
            $this->memberIDList = $memberIDList;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\MemberDirectorySearch
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get avail value
     * @return bool|null
     */
    public function getAvail()
    {
        return $this->avail;
    }
    /**
     * Set avail value
     * @param bool $avail
     * @return \StructType\MemberDirectorySearch
     */
    public function setAvail($avail = null)
    {
        // validation for constraint: boolean
        if (!is_null($avail) && !is_bool($avail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($avail, true), gettype($avail)), __LINE__);
        }
        $this->avail = $avail;
        return $this;
    }
    /**
     * Get location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->location) ? $this->location : null;
    }
    /**
     * Set location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return \StructType\MemberDirectorySearch
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->location);
        } else {
            $this->location = $location;
        }
        return $this;
    }
    /**
     * Get craft value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCraft()
    {
        return isset($this->craft) ? $this->craft : null;
    }
    /**
     * Set craft value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $craft
     * @return \StructType\MemberDirectorySearch
     */
    public function setCraft($craft = null)
    {
        // validation for constraint: string
        if (!is_null($craft) && !is_string($craft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($craft, true), gettype($craft)), __LINE__);
        }
        if (is_null($craft) || (is_array($craft) && empty($craft))) {
            unset($this->craft);
        } else {
            $this->craft = $craft;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberDirectorySearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
