<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://iatse798ws.preview.winmill.com/ServiceLocal798.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://iatse798ws.preview.winmill.com/ServiceLocal798.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetLoginMessage operation/method
 */
if ($get->GetLoginMessage(new \StructType\GetLoginMessage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSSOToken operation/method
 */
if ($get->GetSSOToken(new \StructType\GetSSOToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateServiceCredentials operation/method
 */
if ($create->CreateServiceCredentials(new \StructType\CreateServiceCredentials()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for RetrieveLogin operation/method
 */
if ($retrieve->RetrieveLogin(new \StructType\RetrieveLogin()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveAllMemberData operation/method
 */
if ($retrieve->RetrieveAllMemberData(new \StructType\RetrieveAllMemberData()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveSingleMemberData operation/method
 */
if ($retrieve->RetrieveSingleMemberData(new \StructType\RetrieveSingleMemberData()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveAllMemberAvailability operation/method
 */
if ($retrieve->RetrieveAllMemberAvailability(new \StructType\RetrieveAllMemberAvailability()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveSingleMemberAvailability operation/method
 */
if ($retrieve->RetrieveSingleMemberAvailability(new \StructType\RetrieveSingleMemberAvailability()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Member ServiceType
 */
$member = new \ServiceType\Member($options);
/**
 * Sample call for MemberById operation/method
 */
if ($member->MemberById(new \StructType\MemberById()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberContactsById operation/method
 */
if ($member->MemberContactsById(new \StructType\MemberContactsById()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberAddressesById operation/method
 */
if ($member->MemberAddressesById(new \StructType\MemberAddressesById()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberSearchFilterAllCriteria operation/method
 */
if ($member->MemberSearchFilterAllCriteria(new \StructType\MemberSearchFilterAllCriteria()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberDirectorySearch operation/method
 */
if ($member->MemberDirectorySearch(new \StructType\MemberDirectorySearch()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberPasswordUpdate operation/method
 */
if ($member->MemberPasswordUpdate(new \StructType\MemberPasswordUpdate()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberUpdate operation/method
 */
if ($member->MemberUpdate(new \StructType\MemberUpdate()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberDirectoryDelete operation/method
 */
if ($member->MemberDirectoryDelete(new \StructType\MemberDirectoryDelete()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberDirectoryInsert operation/method
 */
if ($member->MemberDirectoryInsert(new \StructType\MemberDirectoryInsert()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberDirectoryUpdate operation/method
 */
if ($member->MemberDirectoryUpdate(new \StructType\MemberDirectoryUpdate()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberContactDelete operation/method
 */
if ($member->MemberContactDelete(new \StructType\MemberContactDelete()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberContactInsert operation/method
 */
if ($member->MemberContactInsert(new \StructType\MemberContactInsert()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberContactUpdate operation/method
 */
if ($member->MemberContactUpdate(new \StructType\MemberContactUpdate()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberAddressDelete operation/method
 */
if ($member->MemberAddressDelete(new \StructType\MemberAddressDelete()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberAddressInsert operation/method
 */
if ($member->MemberAddressInsert(new \StructType\MemberAddressInsert()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberAddressUpdate operation/method
 */
if ($member->MemberAddressUpdate(new \StructType\MemberAddressUpdate()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberAvailabilityUpdate operation/method
 */
if ($member->MemberAvailabilityUpdate(new \StructType\MemberAvailabilityUpdate()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberConfidentialityTypes operation/method
 */
if ($member->MemberConfidentialityTypes(new \StructType\MemberConfidentialityTypes()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberDirectoryTypes operation/method
 */
if ($member->MemberDirectoryTypes(new \StructType\MemberDirectoryTypes()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberCraftTypes operation/method
 */
if ($member->MemberCraftTypes(new \StructType\MemberCraftTypes()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberStatusTypes operation/method
 */
if ($member->MemberStatusTypes(new \StructType\MemberStatusTypes()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for MemberAddressTypes operation/method
 */
if ($member->MemberAddressTypes(new \StructType\MemberAddressTypes()) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Samples for Report ServiceType
 */
$report = new \ServiceType\Report($options);
/**
 * Sample call for ReportWorkInsert operation/method
 */
if ($report->ReportWorkInsert(new \StructType\ReportWorkInsert()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportWorkUpdate operation/method
 */
if ($report->ReportWorkUpdate(new \StructType\ReportWorkUpdate()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportWorkDelete operation/method
 */
if ($report->ReportWorkDelete(new \StructType\ReportWorkDelete()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportWorkByMember operation/method
 */
if ($report->ReportWorkByMember(new \StructType\ReportWorkByMember()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Samples for Invoice ServiceType
 */
$invoice = new \ServiceType\Invoice($options);
/**
 * Sample call for InvoiceByMember operation/method
 */
if ($invoice->InvoiceByMember(new \StructType\InvoiceByMember()) !== false) {
    print_r($invoice->getResult());
} else {
    print_r($invoice->getLastError());
}
/**
 * Samples for Payment ServiceType
 */
$payment = new \ServiceType\Payment($options);
/**
 * Sample call for PaymentTypes operation/method
 */
if ($payment->PaymentTypes(new \StructType\PaymentTypes()) !== false) {
    print_r($payment->getResult());
} else {
    print_r($payment->getLastError());
}
/**
 * Samples for Billing ServiceType
 */
$billing = new \ServiceType\Billing($options);
/**
 * Sample call for BillingDates operation/method
 */
if ($billing->BillingDates(new \StructType\BillingDates()) !== false) {
    print_r($billing->getResult());
} else {
    print_r($billing->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddPayment operation/method
 */
if ($add->AddPayment(new \StructType\AddPayment()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for States ServiceType
 */
$states = new \ServiceType\States($options);
/**
 * Sample call for States operation/method
 */
if ($states->States(new \StructType\States()) !== false) {
    print_r($states->getResult());
} else {
    print_r($states->getLastError());
}
/**
 * Samples for Countries ServiceType
 */
$countries = new \ServiceType\Countries($options);
/**
 * Sample call for Countries operation/method
 */
if ($countries->Countries(new \StructType\Countries()) !== false) {
    print_r($countries->getResult());
} else {
    print_r($countries->getLastError());
}
/**
 * Samples for Shows ServiceType
 */
$shows = new \ServiceType\Shows($options);
/**
 * Sample call for Shows operation/method
 */
if ($shows->Shows(new \StructType\Shows()) !== false) {
    print_r($shows->getResult());
} else {
    print_r($shows->getLastError());
}
/**
 * Samples for Roles ServiceType
 */
$roles = new \ServiceType\Roles($options);
/**
 * Sample call for Roles operation/method
 */
if ($roles->Roles(new \StructType\Roles()) !== false) {
    print_r($roles->getResult());
} else {
    print_r($roles->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateSSOToken operation/method
 */
if ($validate->ValidateSSOToken(new \StructType\ValidateSSOToken()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
