<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMemberAddress ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMemberAddress
 * @subpackage Arrays
 */
class ArrayOfMemberAddress extends AbstractStructArrayBase
{
    /**
     * The MemberAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberAddress[]
     */
    public $MemberAddress;
    /**
     * Constructor method for ArrayOfMemberAddress
     * @uses ArrayOfMemberAddress::setMemberAddress()
     * @param \StructType\MemberAddress[] $memberAddress
     */
    public function __construct(array $memberAddress = array())
    {
        $this
            ->setMemberAddress($memberAddress);
    }
    /**
     * Get MemberAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberAddress[]|null
     */
    public function getMemberAddress()
    {
        return isset($this->MemberAddress) ? $this->MemberAddress : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMemberAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMemberAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMemberAddressForArrayConstraintsFromSetMemberAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMemberAddressMemberAddressItem) {
            // validation for constraint: itemType
            if (!$arrayOfMemberAddressMemberAddressItem instanceof \StructType\MemberAddress) {
                $invalidValues[] = is_object($arrayOfMemberAddressMemberAddressItem) ? get_class($arrayOfMemberAddressMemberAddressItem) : sprintf('%s(%s)', gettype($arrayOfMemberAddressMemberAddressItem), var_export($arrayOfMemberAddressMemberAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MemberAddress property can only contain items of type \StructType\MemberAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MemberAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MemberAddress[] $memberAddress
     * @return \ArrayType\ArrayOfMemberAddress
     */
    public function setMemberAddress(array $memberAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($memberAddressArrayErrorMessage = self::validateMemberAddressForArrayConstraintsFromSetMemberAddress($memberAddress))) {
            throw new \InvalidArgumentException($memberAddressArrayErrorMessage, __LINE__);
        }
        if (is_null($memberAddress) || (is_array($memberAddress) && empty($memberAddress))) {
            unset($this->MemberAddress);
        } else {
            $this->MemberAddress = $memberAddress;
        }
        return $this;
    }
    /**
     * Add item to MemberAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\MemberAddress $item
     * @return \ArrayType\ArrayOfMemberAddress
     */
    public function addToMemberAddress(\StructType\MemberAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MemberAddress) {
            throw new \InvalidArgumentException(sprintf('The MemberAddress property can only contain items of type \StructType\MemberAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MemberAddress[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MemberAddress|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MemberAddress|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MemberAddress|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MemberAddress|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MemberAddress|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MemberAddress
     */
    public function getAttributeName()
    {
        return 'MemberAddress';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMemberAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
