<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportWork StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportWork
 * @subpackage Structs
 */
class ReportWork extends DbActionBase
{
    /**
     * The CanEdit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanEdit;
    /**
     * The CraftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CraftId;
    /**
     * The CreateBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateBy;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The DaysWorked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DaysWorked;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The IsCheckOff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCheckOff;
    /**
     * The MemberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberId;
    /**
     * The MemberWorkHistoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberWorkHistoryId;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoleId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShowId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The UpdateBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdateBy;
    /**
     * The UpdateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateDate;
    /**
     * Constructor method for ReportWork
     * @uses ReportWork::setCanEdit()
     * @uses ReportWork::setCraftId()
     * @uses ReportWork::setCreateBy()
     * @uses ReportWork::setCreateDate()
     * @uses ReportWork::setDaysWorked()
     * @uses ReportWork::setEndDate()
     * @uses ReportWork::setIsCheckOff()
     * @uses ReportWork::setMemberId()
     * @uses ReportWork::setMemberWorkHistoryId()
     * @uses ReportWork::setRoleId()
     * @uses ReportWork::setShowId()
     * @uses ReportWork::setStartDate()
     * @uses ReportWork::setUpdateBy()
     * @uses ReportWork::setUpdateDate()
     * @param bool $canEdit
     * @param int $craftId
     * @param string $createBy
     * @param string $createDate
     * @param int $daysWorked
     * @param string $endDate
     * @param bool $isCheckOff
     * @param int $memberId
     * @param int $memberWorkHistoryId
     * @param int $roleId
     * @param int $showId
     * @param string $startDate
     * @param string $updateBy
     * @param string $updateDate
     */
    public function __construct($canEdit = null, $craftId = null, $createBy = null, $createDate = null, $daysWorked = null, $endDate = null, $isCheckOff = null, $memberId = null, $memberWorkHistoryId = null, $roleId = null, $showId = null, $startDate = null, $updateBy = null, $updateDate = null)
    {
        $this
            ->setCanEdit($canEdit)
            ->setCraftId($craftId)
            ->setCreateBy($createBy)
            ->setCreateDate($createDate)
            ->setDaysWorked($daysWorked)
            ->setEndDate($endDate)
            ->setIsCheckOff($isCheckOff)
            ->setMemberId($memberId)
            ->setMemberWorkHistoryId($memberWorkHistoryId)
            ->setRoleId($roleId)
            ->setShowId($showId)
            ->setStartDate($startDate)
            ->setUpdateBy($updateBy)
            ->setUpdateDate($updateDate);
    }
    /**
     * Get CanEdit value
     * @return bool|null
     */
    public function getCanEdit()
    {
        return $this->CanEdit;
    }
    /**
     * Set CanEdit value
     * @param bool $canEdit
     * @return \StructType\ReportWork
     */
    public function setCanEdit($canEdit = null)
    {
        // validation for constraint: boolean
        if (!is_null($canEdit) && !is_bool($canEdit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canEdit, true), gettype($canEdit)), __LINE__);
        }
        $this->CanEdit = $canEdit;
        return $this;
    }
    /**
     * Get CraftId value
     * @return int|null
     */
    public function getCraftId()
    {
        return $this->CraftId;
    }
    /**
     * Set CraftId value
     * @param int $craftId
     * @return \StructType\ReportWork
     */
    public function setCraftId($craftId = null)
    {
        // validation for constraint: int
        if (!is_null($craftId) && !(is_int($craftId) || ctype_digit($craftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($craftId, true), gettype($craftId)), __LINE__);
        }
        $this->CraftId = $craftId;
        return $this;
    }
    /**
     * Get CreateBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateBy()
    {
        return isset($this->CreateBy) ? $this->CreateBy : null;
    }
    /**
     * Set CreateBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createBy
     * @return \StructType\ReportWork
     */
    public function setCreateBy($createBy = null)
    {
        // validation for constraint: string
        if (!is_null($createBy) && !is_string($createBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createBy, true), gettype($createBy)), __LINE__);
        }
        if (is_null($createBy) || (is_array($createBy) && empty($createBy))) {
            unset($this->CreateBy);
        } else {
            $this->CreateBy = $createBy;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\ReportWork
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get DaysWorked value
     * @return int|null
     */
    public function getDaysWorked()
    {
        return $this->DaysWorked;
    }
    /**
     * Set DaysWorked value
     * @param int $daysWorked
     * @return \StructType\ReportWork
     */
    public function setDaysWorked($daysWorked = null)
    {
        // validation for constraint: int
        if (!is_null($daysWorked) && !(is_int($daysWorked) || ctype_digit($daysWorked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysWorked, true), gettype($daysWorked)), __LINE__);
        }
        $this->DaysWorked = $daysWorked;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ReportWork
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get IsCheckOff value
     * @return bool|null
     */
    public function getIsCheckOff()
    {
        return $this->IsCheckOff;
    }
    /**
     * Set IsCheckOff value
     * @param bool $isCheckOff
     * @return \StructType\ReportWork
     */
    public function setIsCheckOff($isCheckOff = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCheckOff) && !is_bool($isCheckOff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCheckOff, true), gettype($isCheckOff)), __LINE__);
        }
        $this->IsCheckOff = $isCheckOff;
        return $this;
    }
    /**
     * Get MemberId value
     * @return int|null
     */
    public function getMemberId()
    {
        return $this->MemberId;
    }
    /**
     * Set MemberId value
     * @param int $memberId
     * @return \StructType\ReportWork
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: int
        if (!is_null($memberId) && !(is_int($memberId) || ctype_digit($memberId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        $this->MemberId = $memberId;
        return $this;
    }
    /**
     * Get MemberWorkHistoryId value
     * @return int|null
     */
    public function getMemberWorkHistoryId()
    {
        return $this->MemberWorkHistoryId;
    }
    /**
     * Set MemberWorkHistoryId value
     * @param int $memberWorkHistoryId
     * @return \StructType\ReportWork
     */
    public function setMemberWorkHistoryId($memberWorkHistoryId = null)
    {
        // validation for constraint: int
        if (!is_null($memberWorkHistoryId) && !(is_int($memberWorkHistoryId) || ctype_digit($memberWorkHistoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberWorkHistoryId, true), gettype($memberWorkHistoryId)), __LINE__);
        }
        $this->MemberWorkHistoryId = $memberWorkHistoryId;
        return $this;
    }
    /**
     * Get RoleId value
     * @return int|null
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param int $roleId
     * @return \StructType\ReportWork
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: int
        if (!is_null($roleId) && !(is_int($roleId) || ctype_digit($roleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
    /**
     * Get ShowId value
     * @return int|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param int $showId
     * @return \StructType\ReportWork
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: int
        if (!is_null($showId) && !(is_int($showId) || ctype_digit($showId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ReportWork
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get UpdateBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateBy()
    {
        return isset($this->UpdateBy) ? $this->UpdateBy : null;
    }
    /**
     * Set UpdateBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateBy
     * @return \StructType\ReportWork
     */
    public function setUpdateBy($updateBy = null)
    {
        // validation for constraint: string
        if (!is_null($updateBy) && !is_string($updateBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateBy, true), gettype($updateBy)), __LINE__);
        }
        if (is_null($updateBy) || (is_array($updateBy) && empty($updateBy))) {
            unset($this->UpdateBy);
        } else {
            $this->UpdateBy = $updateBy;
        }
        return $this;
    }
    /**
     * Get UpdateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->UpdateDate;
    }
    /**
     * Set UpdateDate value
     * @param string $updateDate
     * @return \StructType\ReportWork
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        $this->UpdateDate = $updateDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportWork
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
