<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberAvailability StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MemberAvailability
 * @subpackage Structs
 */
class MemberAvailability extends DbActionBase
{
    /**
     * The IsAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailable;
    /**
     * The MemberID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MemberID;
    /**
     * Constructor method for MemberAvailability
     * @uses MemberAvailability::setIsAvailable()
     * @uses MemberAvailability::setMemberID()
     * @param bool $isAvailable
     * @param int $memberID
     */
    public function __construct($isAvailable = null, $memberID = null)
    {
        $this
            ->setIsAvailable($isAvailable)
            ->setMemberID($memberID);
    }
    /**
     * Get IsAvailable value
     * @return bool|null
     */
    public function getIsAvailable()
    {
        return $this->IsAvailable;
    }
    /**
     * Set IsAvailable value
     * @param bool $isAvailable
     * @return \StructType\MemberAvailability
     */
    public function setIsAvailable($isAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailable) && !is_bool($isAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailable, true), gettype($isAvailable)), __LINE__);
        }
        $this->IsAvailable = $isAvailable;
        return $this;
    }
    /**
     * Get MemberID value
     * @return int|null
     */
    public function getMemberID()
    {
        return $this->MemberID;
    }
    /**
     * Set MemberID value
     * @param int $memberID
     * @return \StructType\MemberAvailability
     */
    public function setMemberID($memberID = null)
    {
        // validation for constraint: int
        if (!is_null($memberID) && !(is_int($memberID) || ctype_digit($memberID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberID, true), gettype($memberID)), __LINE__);
        }
        $this->MemberID = $memberID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberAvailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
