<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPayment StructType
 * @subpackage Structs
 */
class AddPayment extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The memberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $memberId;
    /**
     * The paymentTypeValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $paymentTypeValue;
    /**
     * The referenceNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $referenceNum;
    /**
     * The paymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $paymentAmount;
    /**
     * Constructor method for AddPayment
     * @uses AddPayment::setWebServiceCredentials()
     * @uses AddPayment::setMemberId()
     * @uses AddPayment::setPaymentTypeValue()
     * @uses AddPayment::setReferenceNum()
     * @uses AddPayment::setPaymentAmount()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param int $memberId
     * @param string $paymentTypeValue
     * @param string $referenceNum
     * @param float $paymentAmount
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, $memberId = null, $paymentTypeValue = null, $referenceNum = null, $paymentAmount = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setMemberId($memberId)
            ->setPaymentTypeValue($paymentTypeValue)
            ->setReferenceNum($referenceNum)
            ->setPaymentAmount($paymentAmount);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\AddPayment
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get memberId value
     * @return int|null
     */
    public function getMemberId()
    {
        return $this->memberId;
    }
    /**
     * Set memberId value
     * @param int $memberId
     * @return \StructType\AddPayment
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: int
        if (!is_null($memberId) && !(is_int($memberId) || ctype_digit($memberId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        $this->memberId = $memberId;
        return $this;
    }
    /**
     * Get paymentTypeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTypeValue()
    {
        return isset($this->paymentTypeValue) ? $this->paymentTypeValue : null;
    }
    /**
     * Set paymentTypeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTypeValue
     * @return \StructType\AddPayment
     */
    public function setPaymentTypeValue($paymentTypeValue = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeValue) && !is_string($paymentTypeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeValue, true), gettype($paymentTypeValue)), __LINE__);
        }
        if (is_null($paymentTypeValue) || (is_array($paymentTypeValue) && empty($paymentTypeValue))) {
            unset($this->paymentTypeValue);
        } else {
            $this->paymentTypeValue = $paymentTypeValue;
        }
        return $this;
    }
    /**
     * Get referenceNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNum()
    {
        return isset($this->referenceNum) ? $this->referenceNum : null;
    }
    /**
     * Set referenceNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNum
     * @return \StructType\AddPayment
     */
    public function setReferenceNum($referenceNum = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNum) && !is_string($referenceNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNum, true), gettype($referenceNum)), __LINE__);
        }
        if (is_null($referenceNum) || (is_array($referenceNum) && empty($referenceNum))) {
            unset($this->referenceNum);
        } else {
            $this->referenceNum = $referenceNum;
        }
        return $this;
    }
    /**
     * Get paymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }
    /**
     * Set paymentAmount value
     * @param float $paymentAmount
     * @return \StructType\AddPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->paymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
