<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberSearchFilterAllCriteria StructType
 * @subpackage Structs
 */
class MemberSearchFilterAllCriteria extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SearchCriteria
     */
    public $criteria;
    /**
     * Constructor method for MemberSearchFilterAllCriteria
     * @uses MemberSearchFilterAllCriteria::setWebServiceCredentials()
     * @uses MemberSearchFilterAllCriteria::setCriteria()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param \StructType\SearchCriteria $criteria
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, \StructType\SearchCriteria $criteria = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setCriteria($criteria);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberSearchFilterAllCriteria
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SearchCriteria|null
     */
    public function getCriteria()
    {
        return isset($this->criteria) ? $this->criteria : null;
    }
    /**
     * Set criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SearchCriteria $criteria
     * @return \StructType\MemberSearchFilterAllCriteria
     */
    public function setCriteria(\StructType\SearchCriteria $criteria = null)
    {
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->criteria);
        } else {
            $this->criteria = $criteria;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberSearchFilterAllCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
