<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberDirectoryDelete StructType
 * @subpackage Structs
 */
class MemberDirectoryDelete extends AbstractStructBase
{
    /**
     * The webServiceCredentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCredential
     */
    public $webServiceCredentials;
    /**
     * The directory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberDirectory
     */
    public $directory;
    /**
     * Constructor method for MemberDirectoryDelete
     * @uses MemberDirectoryDelete::setWebServiceCredentials()
     * @uses MemberDirectoryDelete::setDirectory()
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @param \StructType\MemberDirectory $directory
     */
    public function __construct(\StructType\ServiceCredential $webServiceCredentials = null, \StructType\MemberDirectory $directory = null)
    {
        $this
            ->setWebServiceCredentials($webServiceCredentials)
            ->setDirectory($directory);
    }
    /**
     * Get webServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCredential|null
     */
    public function getWebServiceCredentials()
    {
        return isset($this->webServiceCredentials) ? $this->webServiceCredentials : null;
    }
    /**
     * Set webServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceCredential $webServiceCredentials
     * @return \StructType\MemberDirectoryDelete
     */
    public function setWebServiceCredentials(\StructType\ServiceCredential $webServiceCredentials = null)
    {
        if (is_null($webServiceCredentials) || (is_array($webServiceCredentials) && empty($webServiceCredentials))) {
            unset($this->webServiceCredentials);
        } else {
            $this->webServiceCredentials = $webServiceCredentials;
        }
        return $this;
    }
    /**
     * Get directory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberDirectory|null
     */
    public function getDirectory()
    {
        return isset($this->directory) ? $this->directory : null;
    }
    /**
     * Set directory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MemberDirectory $directory
     * @return \StructType\MemberDirectoryDelete
     */
    public function setDirectory(\StructType\MemberDirectory $directory = null)
    {
        if (is_null($directory) || (is_array($directory) && empty($directory))) {
            unset($this->directory);
        } else {
            $this->directory = $directory;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberDirectoryDelete
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
